@php  
    $logo = \App\Models\Utility::getLogo(); 
@endphp
<!-- Main Sidebar Container -->
 <aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="#" class="brand-link">
      {{-- <img src="{{ asset('dist/img/AdminLTELogo.png') }}" alt="AdminLTE Logo" class="brand-image img-circle elevation-3" style="opacity: .8"> --}}
      <img src="{{ asset($logo) }}" alt="Suhu Logo" class="brand-image img-circle elevation-3" style="opacity: .8">
      <span class="brand-text font-weight-light">{{ config('app.name', 'Laravel') }}</span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
      
      <!-- SidebarSearch Form -->
      <div class="form-inline">
        <div class="input-group" data-widget="sidebar-search">
          <input class="form-control form-control-sidebar" type="search" placeholder="Search" aria-label="Search">
          <div class="input-group-append">
            <button class="btn btn-sidebar">
              <i class="fas fa-search fa-fw"></i>
            </button>
          </div>
        </div>
      </div>

      <!-- Sidebar Menu -->
      <nav class="mt-2">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
          <!-- Add icons to the links using the .nav-icon class
               with font-awesome or any other icon font library -->
          @can('manage dashboard')                     
            <li class="nav-item">
              <a href="{{ route('dashboard') }}" class="nav-link {{ (Request::routeIs('dashboard*')) ? 'active' : '' }}">
                <i class="nav-icon fas fa-tachometer-alt"></i>
                <p>
                  {{ __('Dashboard') }}
                </p>
              </a>
            </li>          
          @endcan    
          @can('manage merchant dashboard')       
            <li class="nav-item">
              <a href="{{ route('dashboard') }}" class="nav-link {{ (Request::routeIs('dashboard*')) ? 'active' : '' }}">
                <i class="nav-icon fas fa-tachometer-alt"></i>
                <p>
                  {{ __('Dashboard') }}
                </p>
              </a>
            </li>           
          @endcan
          @can('manage admin user')
          <li class="nav-item {{ (Request::routeIs('user*') || Request::routeIs('role*')) ? 'menu-open' : '' }}">
            <a href="#" class="nav-link {{ (Request::routeIs('user*') || Request::routeIs('role*')) ? 'active' : '' }}">
              <i class="nav-icon fas fa-user-cog"></i>
              <p>
                {{ __('Manage Users') }}
                <i class="right fas fa-angle-left"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="{{ route('user.index') }}" class="nav-link {{ Request::routeIs('user*') ? 'active' : '' }}">
                  {{-- <i class="far fas fa-users nav-icon"></i> --}}
                  <i class="fas fa-angle-right nav-icon"></i>
                  <p>{{ __('Users') }}</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="{{ route('role.index') }}" class="nav-link {{ Request::routeIs('role*') ? 'active' : '' }}">
                  {{-- <i class="far fas fa-user-tag nav-icon"></i> --}}
                  <i class="fas fa-angle-right nav-icon"></i>
                  <p>{{ __('Roles') }}</p>
                </a>
              </li>
            </ul>
          </li>
          @endcan
          @can('manage merchant')
          <li class="nav-item {{ (Request::routeIs('merchant*')) ? 'active' : '' }}">
            <a href="{{ route('merchant.index') }}" class="nav-link {{ Request::routeIs('merchant*') ? 'active' : '' }}">
              <i class="nav-icon fas fa-user-shield"></i>
              <p>
                {{ __('Merchant') }}
              </p>
            </a>
          </li>
          @endcan
          @can('manage driver')
          <li class="nav-item {{ (Request::routeIs('driver*') || Request::routeIs('vehicle*')) ? 'menu-open' : '' }}">
            <a href="#" class="nav-link {{ (Request::routeIs('driver*') || Request::routeIs('vehicle*')) ? 'active' : '' }}">
              <i class="nav-icon fas fa-taxi"></i>
              <p>
                {{ __('Manage Driver') }}
                <i class="right fas fa-angle-left"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="{{ route('driver.index') }}" class="nav-link {{ Request::routeIs('driver*') ? 'active' : '' }}">
                  {{-- <i class="far fas fa-people-carry nav-icon"></i> --}}
                  <i class="fas fa-angle-right nav-icon"></i>
                  <p>{{ __('Driver') }}</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="{{ route('vehicle.index') }}" class="nav-link {{ Request::routeIs('vehicle*') ? 'active' : '' }}">
                  {{-- <i class="far fas fa-truck nav-icon"></i> --}}
                  <i class="fas fa-angle-right nav-icon"></i>
                  <p>{{ __('Vehicle') }}</p>
                </a>
              </li>
            </ul>
          </li>
          @endcan
          @can('manage customer')
          <li class="nav-item {{ (Request::routeIs('customer*')) ? 'active' : '' }}">
            <a href="{{ route('customer.index') }}" class="nav-link {{ (Request::routeIs('customer*')) ? 'active' : '' }}">
              <i class="nav-icon fas fa-user"></i>
              <p>
                {{ __('Customer') }}
              </p>
            </a>
          </li>
          @endcan
          @can('manage order')
          <li class="nav-item {{ (Request::routeIs('order*')) ? 'active' : '' }}">
            <a href="{{ route('order.index') }}" class="nav-link {{ (Request::routeIs('order*')) ? 'active' : '' }}">
              <i class="nav-icon fas fa-sort"></i>
              <p>
                {{ __('Order') }}
              </p>
            </a>
          </li>
          @endcan
          @can('manage sales person')
          <li class="nav-item {{ (Request::routeIs('sales-person*')) ? 'active' : '' }}">
            <a href="{{ route('sales-person.index') }}" class="nav-link {{ (Request::routeIs('sales-person*')) ? 'active' : '' }}">
              <i class="nav-icon fas fa-house-user"></i>
              <p>
                {{ __('Sales Person') }}
              </p>
            </a>
          </li>
          @endcan
          @can('manage package setting')
          <li class="nav-item {{ (Request::routeIs('package-setting*')) ? 'active' : '' }}">
            <a href="{{ route('package-setting.index') }}" class="nav-link {{ (Request::routeIs('package-setting*')) ? 'active' : '' }}">
              <i class="nav-icon fas fa-money-bill"></i>
              <p>
                {{ __('Package Setting') }}
              </p>
            </a>
          </li>
          @endcan
          @can('manage payment record')
          <li class="nav-item">
            <a href="#" class="nav-link">
              <i class="nav-icon fas fa-money-check-alt"></i>
              <p>
                {{ __('Payment Record') }}
              </p>
            </a>
          </li>
          @endcan
          @can('manage topup')
          <li class="nav-item">
            <a href="#" class="nav-link">
              <i class="nav-icon fas fa-coins"></i>
              <p>
                {{ __('Topup') }}
              </p>
            </a>
          </li>
          @endcan
          @can('manage product category')
          <li class="nav-item {{ (Request::routeIs('contact-type*')) ? 'active' : '' }}">
            <a href="{{ route('contact-type.index') }}" class="nav-link {{ Request::routeIs('contact-type*') ? 'active' : '' }}">
              <i class="nav-icon fas fa-sort-alpha-up"></i>
              <p>
                {{ __('Contact Type') }}
              </p>
            </a>
          </li>
          @endcan
          @can('manage hub')
          <li class="nav-item {{ (Request::routeIs('hub*')) ? 'active' : '' }}">
            <a href="{{ route('hub.index') }}" class="nav-link {{ Request::routeIs('hub*') ? 'active' : '' }}">
              <i class="nav-icon fas fa-warehouse"></i>
              <p>
                {{ __('Hub') }}
              </p>
            </a>
          </li>
          @endcan
          @can('manage area')
          <li class="nav-item {{ (Request::routeIs('area*')) ? 'active' : '' }}">
            <a href="{{ route('area.index') }}" class="nav-link {{ Request::routeIs('area*') ? 'active' : '' }}">
              <i class="nav-icon fas fa-map-marker-alt"></i>
              <p>
                {{ __('Area') }}
              </p>
            </a>
          </li>
          @endcan
          @can('manage setting')
              <li class="nav-item {{ (Request::routeIs('setting*')) ? 'active' : '' }}">
                <a href="{{ route('setting.index') }}" class="nav-link {{ (Request::routeIs('setting*')) ? 'active' : '' }}">
                  <i class="nav-icon fas fa-cog"></i>
                  <p>
                    {{ __('Setting') }}
                  </p>
                </a>
              </li>
            @endcan
            @can('manage merchant transaction') 
            <li class="nav-item">
              <a href="#" class="nav-link">
                <i class="nav-icon fas fa-exchange-alt"></i>
                <p>
                  {{ __('Transaction') }}
                </p>
              </a>
            </li>
           @endcan
            @can('manage topup history')
              <li class="nav-item">
                <a href="#" class="nav-link">
                  <i class="nav-icon fas fa-history"></i>
                  <p>
                    {{ __('Topup History') }}
                  </p>
                </a>
              </li>
            @endcan
            @can('manage merchant setting')
              <li class="nav-item">
                <a href="#" class="nav-link">
                  <i class="nav-icon fas fa-cog"></i>
                  <p>
                    {{ __('Setting') }}
                  </p>
                </a>
              </li>
            @endcan
          {{-- @can('manage vehicle type')
          <li class="nav-item {{ (Request::routeIs('vehicle-type*')) ? 'active' : '' }}">
            <a href="{{ route('vehicle-type.index') }}" class="nav-link {{ (Request::routeIs('vehicle-type*')) ? 'active' : '' }}">
              <i class="nav-icon fas fa-plane"></i>
              <p>
                {{ __('Vehicle Type') }}
              </p>
            </a>
          </li>
          @endcan --}}
          {{-- @endif     
          @if (\Auth::user()->role == "MERCHANT" || \Auth::user()->role == "SALES_PERSON")
                     
            @can('manage merchant dashboard')
            <li class="nav-item">
              <a href="{{ route('dashboard') }}" class="nav-link {{ (Request::routeIs('dashboard*')) ? 'active' : '' }}">
                <i class="nav-icon fas fa-tachometer-alt"></i>
                <p>
                  {{ __('Dashboard') }}
                </p>
              </a>
            </li>
            @endcan
            @can('manage sales person')
              <li class="nav-item {{ (Request::routeIs('merchant.sales-person*')) ? 'active' : '' }}">
                <a href="{{ route('merchant.sales-person.index') }}" class="nav-link {{ (Request::routeIs('merchant.sales-person*')) ? 'active' : '' }}">
                  <i class="nav-icon fas fa-house-user"></i>
                  <p>
                    {{ __('Sales Person') }}
                  </p>
                </a>
              </li>
            @endcan
            @can('manage merchant order')
              <li class="nav-item {{ (Request::routeIs('merchant.order*')) ? 'active' : '' }}">
                <a href="{{ route('merchant.order.index') }}" class="nav-link {{ (Request::routeIs('merchant.order*')) ? 'active' : '' }}">
                  <i class="nav-icon fas fa-sort"></i>
                  <p>
                    {{ __('Order') }}
                  </p>
                </a>
              </li>
            @endcan
            @can('manage merchant transaction') 
              <li class="nav-item">
                <a href="#" class="nav-link">
                  <i class="nav-icon fas fa-exchange-alt"></i>
                  <p>
                    {{ __('Transaction') }}
                  </p>
                </a>
              </li>
             @endcan
            @can('manage merchant customer') 
              <li class="nav-item {{ (Request::routeIs('merchant.customer*')) ? 'active' : '' }}">
                <a href="{{ route('merchant.customer.index') }}" class="nav-link {{ (Request::routeIs('merchant.customer*')) ? 'active' : '' }}">
                  <i class="nav-icon fas fa-user-alt"></i>
                  <p>
                    {{ __('Customer') }}
                  </p>
                </a>
              </li>
            @endcan
            @can('manage topup history')
              <li class="nav-item">
                <a href="#" class="nav-link">
                  <i class="nav-icon fas fa-history"></i>
                  <p>
                    {{ __('Topup History') }}
                  </p>
                </a>
              </li>
            @endcan
            @can('manage merchant setting')
              <li class="nav-item">
                <a href="#" class="nav-link">
                  <i class="nav-icon fas fa-cog"></i>
                  <p>
                    {{ __('Setting') }}
                  </p>
                </a>
              </li>
            @endcan
            @endif --}}
        </ul>
      </nav>
      <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
  </aside>